/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.imgcontrol;

import com.quantumdata.imgcontrol.ImageControl;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDPanel;
import java.awt.Cursor;

public abstract class ImageControlPage
extends QDPanel {
    private static final long serialVersionUID = 1L;
    private String m_imgName;
    private static ImageControl m_mainWin;
    private static RemoteInstrument m_instrument;
    private static InstrumentResponse m_lastResp;

    public ImageControlPage(String string) {
        this.m_imgName = string;
    }

    public String getImageName() {
        return this.m_imgName;
    }

    public void activate() {
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ImageControlPage.sendCmd("IMGP /Cache0/Images");
            ImageControlPage.sendCmd("IMGL " + this.m_imgName);
            ImageControlPage.sendCmd("ISUB 0;IMGU;*OPC?");
            this.readAll();
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        this.setCursor(cursor);
    }

    public void load() {
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ImageControlPage.sendCmd("XIMG:PRML " + this.m_imgName);
            this.readAll();
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        this.setCursor(cursor);
    }

    public void save() {
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ImageControlPage.sendCmd("XIMG:PRMS " + this.m_imgName);
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        this.setCursor(cursor);
    }

    protected abstract void readAll() throws InstrumentException;

    public void setToDefaults() {
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ImageControlPage.sendCmd("XIMG:PRMN " + this.m_imgName);
            this.readAll();
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        this.setCursor(cursor);
    }

    public static void setInstrument(RemoteInstrument remoteInstrument) {
        m_instrument = remoteInstrument;
        if (remoteInstrument == null) {
            ImageControlPage.setErrorMsg("Not Connected");
        }
    }

    public static void setMainWin(ImageControl imageControl) {
        m_mainWin = imageControl;
    }

    public static String sendCmd(String string) throws InstrumentException {
        if (m_instrument == null) {
            m_mainWin.setErrorMsg("Not Connected");
            throw new InstrumentException("Not Connected");
        }
        m_lastResp = m_instrument.sendCmd(string);
        if (m_lastResp.isError()) {
            m_mainWin.setErrorMsg(m_lastResp.getResponse());
            throw new InstrumentException(m_lastResp.getResponse());
        }
        ImageControlPage.setErrorMsg("");
        return m_lastResp.getResponse();
    }

    public static int getInt(String string) throws InstrumentException {
        String string2 = ImageControlPage.sendCmd(string);
        return Integer.parseInt(string2);
    }

    protected static void setErrorMsg(String string) {
        m_mainWin.setErrorMsg(string);
    }
}

